/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import OreSpawn.entities.DoomWorm;
import OreSpawn.entities.WormLarge;
import OreSpawn.entities.WormSmall;
import dangerzone.DangerZone;
import dangerzone.InventoryContainer;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityBlockItem;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import java.util.List;
import java.util.ListIterator;
import slick.Texture;

public class WormMedium
extends EntityLiving {
    public int upcount = 10;
    public int downcount = 0;
    public boolean oktoattack = false;

    public WormMedium(World w) {
        super(w);
        this.maxrenderdist = 140;
        this.height = 2.1f;
        this.width = 0.85f;
        this.uniquename = "OreSpawn:WormMedium";
        this.moveSpeed = 0.03f;
        this.setMaxHealth(40.0f);
        this.setHealth(40.0f);
        this.setDefense(1.0f);
        this.setAttackDamage(5.0f);
        this.searchDistance = 9.0f;
        this.attackRange = 3.5f;
        this.movefrequency = 99999;
        this.setExperience(29);
        this.canSwim = false;
        this.takesFallDamage = false;
        this.ignoreCollisions = true;
        this.setCanDespawn(false);
        this.lifetimeticker = DangerZone.rand.nextInt(10000);
        this.temperament = 1;
        this.enable_hostile = true;
        this.daytimespawn = false;
        this.daytimedespawn = false;
        this.nighttimespawn = false;
        this.nighttimedespawn = false;
    }

    public void doAttack(Entity victim) {
        if (!this.oktoattack) {
            return;
        }
        if (this.world.rand.nextBoolean() && victim.has_inventory && victim instanceof Player) {
            Player p = (Player)victim;
            InventoryContainer ic = null;
            int which = 1 + this.world.rand.nextInt(2);
            ic = p.getArmor(which);
            if (ic != null) {
                p.setArmor(which, null);
                this.spititout(ic);
            }
        }
        super.doAttack(victim);
    }

    private void spititout(InventoryContainer ic) {
        EntityBlockItem e = (EntityBlockItem)this.world.createEntityByName(DangerZone.blockitemname, this.dimension, this.posx + (double)((this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 3.0f), this.posy + 1.0, this.posz + (double)((this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 3.0f));
        if (e != null) {
            e.fill(ic);
            e.rotation_pitch = this.world.rand.nextInt(360);
            e.rotation_yaw = this.world.rand.nextInt(360);
            e.rotation_roll = this.world.rand.nextInt(360);
            this.world.spawnEntityInWorld((Entity)e);
        }
    }

    public void doEntityAction(float deltaT) {
        super.doEntityAction(deltaT);
        if (this.getAttacking() && this.timeForMe()) {
            this.takesFallDamage = true;
            this.ignoreCollisions = false;
            this.oktoattack = true;
        } else {
            this.oktoattack = false;
            this.takesFallDamage = false;
            this.ignoreCollisions = true;
            int bid = this.world.getblock(this.dimension, (int)this.posx, (int)(this.posy + 2.75), (int)this.posz);
            this.motiony = bid == Blocks.stone.blockID || bid == Blocks.sand.blockID || bid == Blocks.dirt.blockID || bid == Blocks.grassblock.blockID ? 0.05f : (bid != 0 ? -0.05f : -0.25f);
            this.target = null;
            this.motionz = 0.0f;
            this.motionx = 0.0f;
            this.rotation_yaw_motion = 0.0f;
        }
    }

    private boolean timeForMe() {
        if (this.upcount > 0) {
            --this.upcount;
            if (this.upcount == 0) {
                this.downcount = 50 + this.world.rand.nextInt(75);
            }
        } else {
            if (this.downcount > 0) {
                --this.downcount;
                return false;
            }
            this.upcount = 12 + this.world.rand.nextInt(25);
        }
        List nearby_list = null;
        nearby_list = DangerZone.server.entityManager.findEntitiesInRange(8.0f, this.dimension, this.posx, this.posy, this.posz);
        if (nearby_list != null && !nearby_list.isEmpty()) {
            Entity e = null;
            ListIterator li = nearby_list.listIterator();
            while (li.hasNext()) {
                e = (Entity)li.next();
                if (!(e instanceof WormSmall)) continue;
                return false;
            }
        }
        return true;
    }

    public String getLivingSound() {
        return null;
    }

    public String getHurtSound() {
        return "DangerZone:big_splat";
    }

    public String getDeathSound() {
        return "DangerZone:big_splat";
    }

    public void doDeathDrops() {
        int howmany = 1 + this.world.rand.nextInt(3);
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.moosemeat.itemID, (float)5.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = 1 + this.world.rand.nextInt(3);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.moosebone.itemID, (float)3.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        if (this.world.rand.nextInt(10) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.trophywormmedium.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        super.doDeathDrops();
    }

    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof DoomWorm) {
            return false;
        }
        if (e instanceof WormLarge) {
            return false;
        }
        if (e instanceof WormMedium) {
            return false;
        }
        if (e instanceof WormSmall) {
            return false;
        }
        return e instanceof Player;
    }

    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture((String)"orespawnres/skins/WormMediumtexture.png");
        }
        return this.texture;
    }
}

